import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import java.lang.*;
import java.util.*;
import java.io.*;
import java.awt.image.BufferedImage;
import javax.imageio.*;


class ImageFrame extends JFrame
{

	Frame handleOnThisFrame;
	ViewImagePanel viewPanel;
	Chromozome chromosome;
	BufferedImage image;

	ButtonGroup group = new ButtonGroup();
	JRadioButtonMenuItem view150;
	JRadioButtonMenuItem view256;
	JRadioButtonMenuItem view512;

	public ImageFrame(Chromozome a, BufferedImage i)
	{
		handleOnThisFrame = this;
		chromosome = a;

		//create a image panel
		image = i;
		viewPanel = new ViewImagePanel(image, handleOnThisFrame);

		setTitle("View Image");

        this.setLocation( ( int ) ( Toolkit.getDefaultToolkit().getScreenSize().getWidth() / 2 - getWidth() / 2 -100) ,
                          ( int ) ( Toolkit.getDefaultToolkit().getScreenSize().getHeight() / 2 - getHeight() / 2 -150) ) ;


		// Menu bar creation
		JMenuBar menuBar = new JMenuBar();
		setJMenuBar(menuBar);

		// File menu options
		JMenu fileMenu = new JMenu("File");
		menuBar.add(fileMenu);

		JMenuItem savePNGItem = new JMenuItem("Save Image as PNG");
		fileMenu.add(savePNGItem);
		SavePNGListener savePNGListener = new SavePNGListener();
		savePNGItem.addActionListener(savePNGListener);

		JMenuItem saveChromosomeItem = new JMenuItem("Save Image as Chromosome");
		fileMenu.add(saveChromosomeItem);
		SaveChromosomeListener saveChromosomeListener = new SaveChromosomeListener();
		saveChromosomeItem.addActionListener(saveChromosomeListener);

		fileMenu.addSeparator();

		JMenuItem exit = new JMenuItem("Close");
		fileMenu.add(exit);
		ExitListener exitListener = new ExitListener();
		exit.addActionListener(exitListener);

		//view menu options
		JMenu viewMenu = new JMenu("View");
		menuBar.add(viewMenu);

		view150 = new JRadioButtonMenuItem("150 X 150", true);
		view256 = new JRadioButtonMenuItem("256 X 256", false);
		view512 = new JRadioButtonMenuItem("512 X 512", false);

		group.add(view150);
		group.add(view256);
		group.add(view512);

		viewMenu.add(view150);
		viewMenu.add(view256);
		viewMenu.add(view512);

		ViewListiner viewListener = new ViewListiner();
		view150.addActionListener(viewListener);

		ViewListiner viewListener1 = new ViewListiner();
		view256.addActionListener(viewListener1);

		ViewListiner viewListener2 = new ViewListiner();
		view512.addActionListener(viewListener2);


		// add panel to frame

		Container contentPane = getContentPane();
		contentPane.setLayout(new BorderLayout());
		contentPane.add(viewPanel, BorderLayout.CENTER);
	}

	// listeners

	private class ExitListener implements ActionListener
	{
		public void actionPerformed(ActionEvent event)
		{

            handleOnThisFrame.dispose();
		}
	}

	private class ViewListiner implements ActionListener
	{
		public void actionPerformed(ActionEvent event)
		{	int size = 0;
			if(view150.isSelected())
			{
				size = 150;
			}
			else if(view256.isSelected())
			{
				size = 256;
			}
			else
			{
				size = 512;
			}

			// change size of frame
			handleOnThisFrame.setSize(size+10, size+60);
			//viewPanel.setSize(size, size);
			//viewPanel.revalidate();

			// create a new image of the selected size
			PreCombinedImage preImage = new PreCombinedImage(GeneticOperators.calculateImage(chromosome, size, size));

		 	int[] tempImage = preImage.combineImage(true, true, true);
			BufferedImage tempBufferedImage = new BufferedImage(size, size, BufferedImage.TYPE_INT_ARGB);
		 	tempBufferedImage.setRGB(0, 0, size, size, tempImage, 0, size);
		 	image = tempBufferedImage;

		 	viewPanel.setImage(image);
		 	viewPanel.repaint();
		 	//viewPanel.paintAll(viewPanel.getGraphics());

		}
	}

	private class SavePNGListener implements ActionListener
	{
		public void actionPerformed(ActionEvent event)
		{

			JFileChooser chooser = new JFileChooser();
			ExampleFileFilter filter = new ExampleFileFilter();
			filter.addExtension("PNG");
			filter.setDescription("PNG Images");
			chooser.setFileFilter(filter);

			// set current directory to the location of the code
			File dirFile = new File(System.getProperty("user.dir")+"\\PNG Images");
			chooser.setCurrentDirectory(dirFile);

			int returnVal = chooser.showSaveDialog(handleOnThisFrame);

			// if user hit save, save file to directory.
			if(returnVal == JFileChooser.APPROVE_OPTION)
			{
				 if(image == null)
				 {
					JOptionPane.showMessageDialog( null , "An error has occured, image was not saved." , "Warning!" , JOptionPane.ERROR_MESSAGE ) ;
				 }
				 else
				 {
					 String name = chooser.getSelectedFile().getName();
					 // if the name doesn't have .png, add it
					 if( !name.endsWith(".png") )
						name = name + ".png";

					 name = "\\"+name;

					 try {
							ImageIO.write(image, "png", new File(chooser.getCurrentDirectory() + "" + name));
						}
					 catch (IOException e)
					 {
						 System.out.println("Exception caught.  Was attempting to save PNG.");
					 }
				 }
			}

		}
	}


	private class SaveChromosomeListener implements ActionListener
	{
		public void actionPerformed(ActionEvent event)
		{
			JFileChooser chooser = new JFileChooser();
			ExampleFileFilter filter = new ExampleFileFilter();
			filter.addExtension("TXT");
			filter.setDescription("Chromosomes");
			chooser.setFileFilter(filter);

			// set current directory to the location of the code
			File dirFile = new File(System.getProperty("user.dir")+"\\Chromosomes");
			chooser.setCurrentDirectory(dirFile);

			int returnVal = chooser.showSaveDialog(handleOnThisFrame);

			// if user hit save, save file to directory.
			if(returnVal == JFileChooser.APPROVE_OPTION)
			{
				 if(chromosome == null)
				 {
					JOptionPane.showMessageDialog( null , "An error has occured, image was not saved." , "Warning!" , JOptionPane.ERROR_MESSAGE ) ;
				 }
				 else
				 {
					 String name = chooser.getSelectedFile().getName();
					 // if the name doesn't have .txt, add it
					 if( !name.endsWith(".txt") )
						name = name + ".txt";

					 name = "\\"+name;

					 try {
						   FileOutputStream file = new FileOutputStream(chooser.getCurrentDirectory() + "" + name);


						   String dataString = chromosome.toString();
						   byte data[] = dataString.getBytes();
						   file.write(data);

						   file.close();
						}
					 catch (IOException e)
					 {
						 System.out.println("Exception caught.  Was attempting to save Chromosome.");
					 }
				 }
			}

		}
	}
}